// Plik specyfikacji klasy Rectangle
#ifndef RECTANGLE_H
#define RECTANGLE_H

class Rectangle
{
private:
  double width;     // Szeroko prostokta
  double length;    // Dugo prostokta
public:
  // Klasa wyjtku dla przypadku ujemnej szerokoci prostokta
  class NegativeWidth
  {
  private:
    double value;
  public:
    NegativeWidth(double val)
      { value = val; }

    double getValue() const
      { return value; }
  };

  // Klasa wyjtku dla przypadku ujemnej dugoci prostokta
  class NegativeLength
  {
  private:
    double value;
  public:
    NegativeLength(double val)
      { value = val; }

    double getValue() const
      { return value; }
  };

  // Domylny konstruktor
  Rectangle()
    { width = 0.0; length = 0.0; }

  // Mutatory zdefiniowane w pliku Rectangle.cpp
  void setWidth(double);
  void setLength(double);

  // Akcesory
  double getWidth() const
    { return width; }

  double getLength() const
    { return length; }

  double getArea() const
    { return width * length; }
};
#endif
